#define DX_DBG_MODULE   DX_DBG_GENERAL_VOS

#include "VOS_API/DX_VOS_Paths.h"
#include "DX_VOS_BasePaths.h"
#include "VOS_API/DX_VOS_String.h"


const DxChar* DX_VOS_RootPath(void)
{
  DX_RETURN(DX_VOS_ROOT_PATH);
}

const DxChar* DX_VOS_RomRootPath(void)
{
  DX_RETURN(DX_VOS_ROM_ROOT_PATH);
}

const DxChar* DX_VOS_PublicRootPath(void)
{
  DX_RETURN(DX_VOS_PUBLIC_ROOT_PATH);
}

const DxChar* DX_VOS_DefaultRootDrive(void)
{
  DX_RETURN(DX_VOS_DEFAULT_ROOT_DRIVE);
}

static const DxChar* PrefixData(DxChar* buff, DxUint32 buffSize, const DxChar* prefix, const DxChar* path)
{
  DX_DECLARE(DxStatus, result, DX_SUCCESS);

  result = DX_VOS_StrNCopy(buff, buffSize, prefix);
  result |= DX_VOS_StrNCat(buff, buffSize, path);

  if (result != DX_SUCCESS)
  {
    DX_DBG_PRINT2(DX_DBGPRINT_ERROR_LEVEL, 
          "Path construction failed. prefix: %s, path: %s", prefix, path);
    DX_RETURN(DX_NULL);
  }
  DX_RETURN(buff);
}

const DxChar* DX_VOS_PrefixRootPath(const DxChar* apPath)
{
  static DxChar rootPrefix[DX_VOS_MAX_PATH];
  return PrefixData(rootPrefix, sizeof(rootPrefix), DX_VOS_RootPath(), apPath);
}

const DxChar* DX_VOS_PrefixRomRootPath(const DxChar* apPath)
{
  static DxChar secureRootPrefix[DX_VOS_MAX_PATH];
  return PrefixData(secureRootPrefix, sizeof(secureRootPrefix), DX_VOS_RomRootPath(), apPath);
}

const DxChar* DX_VOS_PrefixPublicRootPath(const DxChar* apPath)
{
  static DxChar publicRootPrefix[DX_VOS_MAX_PATH];
  return PrefixData(publicRootPrefix, sizeof(publicRootPrefix), DX_VOS_PublicRootPath(), apPath);
}

const DxChar* DX_VOS_PrefixDefaultRootDrive(const DxChar* apPath)
{
  static DxChar defaultRootDrive[DX_VOS_MAX_PATH];
  return PrefixData(defaultRootDrive, sizeof(defaultRootDrive), DX_VOS_DefaultRootDrive(), apPath);
}

static DxChar* ExtendPrefixPath(const DxChar* apPrefix, const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize)
{
  DX_DECLARE(DxStatus, result, DX_SUCCESS);
  
  result  = DX_VOS_StrNCopy(apOutputPath, aBuffSize, apPrefix);
  result |= DX_VOS_StrNCat(apOutputPath, aBuffSize, apPostfix);

  if (result != DX_SUCCESS)
  {
      if((DxChar*)DX_NULL != apPrefix && (DxChar*)DX_NULL != apPostfix && (DxChar*)DX_NULL != apOutputPath)
      {
        DX_DBG_PRINT3(DX_DBGPRINT_ERROR_LEVEL, 
          "Path construction failed. prefix: %s, postfix: %s, full path: %s", apPrefix, apPostfix, apOutputPath);
      }
      DX_RETURN(DX_NULL);
  }
  DX_RETURN(apOutputPath);
}

DxChar* DX_VOS_ExtendPrefixRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize)
{
  return ExtendPrefixPath(DX_VOS_RootPath(), apPostfix, apOutputPath, aBuffSize);
}

DxChar* DX_VOS_ExtendPrefixRomRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize)
{
  return ExtendPrefixPath(DX_VOS_RomRootPath(), apPostfix, apOutputPath, aBuffSize);
}

DxChar* DX_VOS_ExtendPrefixPublicRootPath(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize)
{
  return ExtendPrefixPath(DX_VOS_PublicRootPath(), apPostfix, apOutputPath, aBuffSize);
}

DxChar* DX_VOS_ExtendPrefixDefaultRootDrive(const DxChar* apPostfix, DxChar* apOutputPath, DxUint32 aBuffSize)
{
  return ExtendPrefixPath(DX_VOS_DefaultRootDrive(), apPostfix, apOutputPath, aBuffSize);
}